package gov.va.vinci.dart.db.mock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

import gov.va.vinci.dart.biz.RequestParticipantDocument;
import gov.va.vinci.dart.db.RequestParticipantDocumentDAO;

public class RequestParticipantDocumentDAOMock implements RequestParticipantDocumentDAO {
	private static HashMap<Integer,RequestParticipantDocument> IDHash = new HashMap<Integer,RequestParticipantDocument>();
	private static boolean initialized = false;
	private static int idCounter = 1;
	
	@Override
	public void save(RequestParticipantDocument document) {
		if (document == null) {
			throw new IllegalArgumentException();
		}
	
		initializeDocHash();
		
		if (document.getId() == 0) {
			document.setId(idCounter++);
		}
		
		IDHash.put(document.getId(), document);
	}

	@Override
	public void delete(RequestParticipantDocument document) {
		if (document == null) {
			throw new IllegalArgumentException();
		}
		
		initializeDocHash();

		IDHash.remove(document.getId());
	}


	@Override
	public List<RequestParticipantDocument> listByRequestId(int requestId) {
		List<RequestParticipantDocument> result = new ArrayList<RequestParticipantDocument>();
		
		initializeDocHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestParticipantDocument rald = IDHash.get(id);
			if (rald.getRequestId() == requestId) {
				result.add(rald);
			}
		}

		return result;	
	}

	@Override
	public List<RequestParticipantDocument> listByDocumentId(int documentId) {
		List<RequestParticipantDocument> result = new ArrayList<RequestParticipantDocument>();
		
		initializeDocHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestParticipantDocument rald = IDHash.get(id);
			if (rald.getDocumentId() == documentId) {
				result.add(rald);
			}
		}

		return result;	
	}

	@Override
	public List<RequestParticipantDocument> listByRequestAndParticipantId(final int requestId, final int participantId) {
		List<RequestParticipantDocument> result = new ArrayList<RequestParticipantDocument>();
		
		initializeDocHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestParticipantDocument rald = IDHash.get(id);
			if( rald.getRequestId() == requestId && rald.getParticipantId() == participantId ) {	//match both the requestId and the participantId
				result.add(rald);
			}
		}

		return result;	
	}	
	
	@Override
	public List<RequestParticipantDocument> listActiveDocsByRequestAndParticipantId(final int requestId, final int participantId) {
		List<RequestParticipantDocument> result = new ArrayList<RequestParticipantDocument>();
		
		initializeDocHash();
		
		for (Integer id: IDHash.keySet()) {
			RequestParticipantDocument rald = IDHash.get(id);
			
			if( rald.isActive() == true ) {	//active document
				if( rald.getRequestId() == requestId && rald.getParticipantId() == participantId ) {	//match both the requestId and the participantId
					result.add(rald);
				}
			}//end if
		}

		return result;	
	}	


	private void initializeDocHash() {
		if (initialized == true) {
			return;
		}
		initialized = true;
	}

}
